using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;
using Borland.Studio.ToolsAPI;
using BeWise.SharpBuilderTools.Utils;

namespace BeWise.SharpBuilderTools.Gui
{
	public abstract class FrmBaseView : System.Windows.Forms.Form, IComparer
	{
		ArrayList fItems = new ArrayList();
		private System.Windows.Forms.Label lblItem;

		/**************************************************************/
		/*                    Constructor/ Destructor
		/**************************************************************/

		public FrmBaseView()
		{
			InitializeComponent();
			InitializeListView(lvItems);

			this.Text = GetFormText();
			lblItem.Text = GetLabelText();
			tabPage1.Text = GetTabPageText();

			LoadItems();
			LoadItemsInListView();
		}

		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		/**************************************************************/
		/*                         Private
		/**************************************************************/

		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.Button btCancel;
		private System.Windows.Forms.Button btOk;
		private System.Windows.Forms.TabControl TabControl;
		private System.Windows.Forms.TabPage tabPage1;
		private System.Windows.Forms.TextBox txtItem;
		private System.Windows.Forms.ListView lvItems;

		private void txtItem_TextChanged(object sender, System.EventArgs e) {
			LoadItemsInListView();
		}

		private void InitializeComponent() {
			this.btCancel = new System.Windows.Forms.Button();
			this.btOk = new System.Windows.Forms.Button();
			this.TabControl = new System.Windows.Forms.TabControl();
			this.tabPage1 = new System.Windows.Forms.TabPage();
			this.txtItem = new System.Windows.Forms.TextBox();
			this.lvItems = new System.Windows.Forms.ListView();
			this.lblItem = new System.Windows.Forms.Label();
			this.TabControl.SuspendLayout();
			this.tabPage1.SuspendLayout();
			this.SuspendLayout();
			// 
			// btCancel
			// 
			this.btCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btCancel.Location = new System.Drawing.Point(432, 304);
			this.btCancel.Name = "btCancel";
			this.btCancel.TabIndex = 3;
			this.btCancel.Text = "Cancel";
			// 
			// btOk
			// 
			this.btOk.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btOk.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btOk.Location = new System.Drawing.Point(352, 304);
			this.btOk.Name = "btOk";
			this.btOk.TabIndex = 2;
			this.btOk.Text = "Ok";
			this.btOk.Click += new System.EventHandler(this.btOk_Click);
			// 
			// TabControl
			// 
			this.TabControl.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
						| System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.TabControl.Controls.Add(this.tabPage1);
			this.TabControl.Location = new System.Drawing.Point(8, 8);
			this.TabControl.Name = "TabControl";
			this.TabControl.SelectedIndex = 0;
			this.TabControl.Size = new System.Drawing.Size(504, 288);
			this.TabControl.TabIndex = 2;
			this.TabControl.TabStop = false;
			// 
			// tabPage1
			// 
			this.tabPage1.Controls.Add(this.txtItem);
			this.tabPage1.Controls.Add(this.lvItems);
			this.tabPage1.Controls.Add(this.lblItem);
			this.tabPage1.Location = new System.Drawing.Point(4, 22);
			this.tabPage1.Name = "tabPage1";
			this.tabPage1.Size = new System.Drawing.Size(496, 262);
			this.tabPage1.TabIndex = 0;
			this.tabPage1.Text = "Files";
			// 
			// txtItem
			// 
			this.txtItem.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.txtItem.Location = new System.Drawing.Point(80, 8);
			this.txtItem.Name = "txtItem";
			this.txtItem.Size = new System.Drawing.Size(408, 20);
			this.txtItem.TabIndex = 0;
			this.txtItem.Text = "";
			this.txtItem.TextChanged += new System.EventHandler(this.txtItem_TextChanged);
			this.txtItem.KeyUp += new System.Windows.Forms.KeyEventHandler(this.txtItem_KeyUp);
			// 
			// lvItems
			// 
			this.lvItems.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
						| System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.lvItems.FullRowSelect = true;
			this.lvItems.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
			this.lvItems.HideSelection = false;
			this.lvItems.Location = new System.Drawing.Point(8, 32);
			this.lvItems.MultiSelect = false;
			this.lvItems.Name = "lvItems";
			this.lvItems.Size = new System.Drawing.Size(480, 224);
			this.lvItems.TabIndex = 1;
			// 
			// lblItem
			// 
			this.lblItem.Location = new System.Drawing.Point(9, 10);
			this.lblItem.Name = "lblItem";
			this.lblItem.TabIndex = 8;
			// 
			// FrmBaseView
			// 
			this.AcceptButton = this.btOk;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btCancel;
			this.ClientSize = new System.Drawing.Size(520, 334);
			this.Controls.Add(this.TabControl);
			this.Controls.Add(this.btOk);
			this.Controls.Add(this.btCancel);
			this.Name = "FrmBaseView";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "Find File";
			this.Enter += new System.EventHandler(this.FrmBaseView_Enter);
			this.TabControl.ResumeLayout(false);
			this.tabPage1.ResumeLayout(false);
			this.ResumeLayout(false);
		}

		private void btOk_Click(object sender, System.EventArgs e) {
			if (lvItems.SelectedItems.Count > 0) {
				ExecuteItem(lvItems.SelectedItems[0].Tag);
			}

			Close();
		}

		private void txtItem_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e) {
			ListViewItem _SourceItems = null;
			ListViewItem _DestItems = null;

			if (e.KeyCode == Keys.Up) {
				if (lvItems.SelectedItems.Count > 0) {
					_SourceItems = lvItems.SelectedItems[0];

					if (_SourceItems.Index != 0) {
						lvItems.SelectedItems.Clear();
						_DestItems = lvItems.Items[_SourceItems.Index - 1];
						_DestItems.Selected = true;
					}
				}
			}
			else if (e.KeyCode == Keys.Down) {
				if (lvItems.SelectedItems.Count > 0) {
					_SourceItems = lvItems.SelectedItems[0];

					if (_SourceItems.Index < lvItems.Items.Count -1) {
						lvItems.SelectedItems.Clear();
						_DestItems = lvItems.Items[_SourceItems.Index + 1];
						_DestItems.Selected = true;
					}
				}
			}

			if (_DestItems != null) {
				lvItems.EnsureVisible(_DestItems.Index);
			}
		}

        /**************************************************************/
		/*                       Protected
		/**************************************************************/

		protected abstract ListViewItem CreateListViewItem(object aItem);

		protected abstract void ExecuteItem(object aItem);

		protected abstract string GetFormText();

		protected abstract string GetLabelText();

		protected abstract string GetTabPageText();

		protected virtual void InitializeListView(ListView aListView) {
			ColumnHeader _Col = new ColumnHeader();
			_Col.Text = "Names";
			_Col.Width = lvItems.Width -4;

			lvItems.Columns.Add(_Col);
			lvItems.View = View.Details;
			lvItems.DoubleClick += new EventHandler(btOk_Click);

		}

		protected virtual bool ItemIsVisible(string aFilter, object aItem) {
			return true;
		}

		/**************************************************************/
		/*                         Public
		/**************************************************************/

		public virtual int Compare(object x, object y) {
			return 0;
		}

		public void LoadItemsInListView() {
			Items.Sort(this);

			object _SelectedItem = null;
			try {
				lvItems.BeginUpdate();
				try {
					if (lvItems.SelectedItems.Count > 0) {
						_SelectedItem = lvItems.SelectedItems[0].Tag;
					}

					lvItems.Items.Clear();

					for (int i = 0; i < fItems.Count; i ++) {
						if (ItemIsVisible(txtItem.Text, fItems[i])) {
							ListViewItem _Item = CreateListViewItem(fItems[i]);
							lvItems.Items.Add(_Item);
						}
					}
				}
				finally {
					lvItems.EndUpdate();
				}
			}
			finally {
				if (lvItems.Items.Count > 0) {
					lvItems.Items[0].Selected = true;

					for (int j = 0; j < lvItems.Items.Count; j++) {
						if (lvItems.Items[j].Tag == _SelectedItem) {
							lvItems.Items[j].Selected = true;
							break;
						}
					}
				}
			}
		}

		public abstract void LoadItems();

		/**************************************************************/
		/*                       Properties
		/**************************************************************/

		public ArrayList Items {
			get {
            	return fItems;
			}
		}

		private void FrmBaseView_Enter(object sender, System.EventArgs e) {
			txtItem.Focus();
		}
	}
}
